<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Onboarding - Fingpay AEPS</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
        }

        .header {
            text-align: center;
            color: white;
            margin-bottom: 30px;
        }

        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
        }

        .card {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        .required {
            color: red;
        }

        input[type="text"],
        input[type="email"],
        input[type="tel"],
        input[type="date"],
        textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }

        input:focus,
        textarea:focus {
            outline: none;
            border-color: #667eea;
        }

        .btn-submit {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s;
            margin-top: 10px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .response-container {
            margin-top: 20px;
            padding: 20px;
            border-radius: 8px;
            display: none;
        }

        .response-container.show {
            display: block;
            animation: slideDown 0.3s;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .response-success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }

        .response-error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .loading {
            display: none;
            text-align: center;
            padding: 20px;
        }

        .loading.show {
            display: block;
        }

        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .back-link {
            display: inline-block;
            color: white;
            text-decoration: none;
            margin-bottom: 20px;
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            transition: background 0.3s;
        }

        .back-link:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="index.php" class="back-link">← Back to Portal</a>
        
        <div class="header">
            <h1>👤 User Onboarding</h1>
            <p>User Registration with Fingpay AEPS</p>
        </div>

        <div class="card">
            <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 20px; margin-bottom: 20px; border-radius: 8px;">
                <h2 style="color: #856404; margin-bottom: 15px; font-size: 1.3em;">
                    ⚠️ API Not Available
                </h2>
                <p style="color: #856404; line-height: 1.6; margin-bottom: 10px;">
                    <strong>User Onboarding API is NOT available in Fingpay AEPS API documentation.</strong>
                </p>
                <p style="color: #856404; line-height: 1.6; margin-bottom: 10px;">
                    This feature was implemented based on assumptions, but after reviewing the official documentation 
                    (<strong>Fingpay Services API Doc 04-01-2025 (8).pdf</strong>), it has been confirmed that this API does not exist.
                </p>
                <p style="color: #856404; line-height: 1.6; margin-bottom: 10px;">
                    <strong>Available APIs in Documentation:</strong>
                </p>
                <ul style="color: #856404; margin-left: 20px; line-height: 1.8;">
                    <li>✅ Cash Withdrawal</li>
                    <li>✅ Balance Inquiry</li>
                    <li>✅ Mini Statement</li>
                    <li>✅ Cash Deposit</li>
                    <li>✅ Bank List</li>
                    <li>✅ EKYC Verification (if in documentation)</li>
                </ul>
                <p style="color: #856404; line-height: 1.6; margin-top: 15px; font-style: italic;">
                    For user registration or onboarding, please contact Fingpay support or use the official admin portal.
                </p>
            </div>

            <div style="text-align: center; padding: 20px;">
                <a href="index.php" style="display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; text-decoration: none; border-radius: 8px; font-weight: bold;">
                    ← Back to Main Portal
                </a>
            </div>
        </div>
    </div>
</body>
</html>

