<?php
/**
 * Quick Server Test Script
 * Test if server is running and endpoints work
 */

echo "=== Fingpay AEPS Server Test ===\n\n";

// Test 1: Check if server can access files
echo "1. Checking files...\n";
if (file_exists('api_config.php')) {
    echo "   ✓ api_config.php exists\n";
} else {
    echo "   ✗ api_config.php NOT FOUND\n";
}

if (file_exists('index.html')) {
    echo "   ✓ index.html exists\n";
} else {
    echo "   ✗ index.html NOT FOUND\n";
}

// Test 2: Check configuration
echo "\n2. Checking configuration...\n";
if (file_exists('api_config.php')) {
    $config = require 'api_config.php';
    if (isset($config['credentials']['merchant_id'])) {
        echo "   ✓ Merchant ID: " . $config['credentials']['merchant_id'] . "\n";
    }
    if (isset($config['credentials']['username'])) {
        echo "   ✓ Username: " . $config['credentials']['username'] . "\n";
    }
}

// Test 3: Check certificate
echo "\n3. Checking certificate...\n";
$certPath = __DIR__ . '/../fingpay_public_production.txt';
if (file_exists($certPath)) {
    echo "   ✓ Certificate file exists\n";
} else {
    echo "   ⚠ Certificate file not found at: $certPath\n";
}

// Test 4: Test bank list function
echo "\n4. Testing bank list...\n";
if (file_exists('bank_list.php')) {
    require_once 'bank_list.php';
    $banks = getBankList();
    echo "   ✓ Bank list loaded: " . count($banks) . " banks\n";
    if (count($banks) > 0) {
        echo "   Sample: " . array_key_first($banks) . " - " . reset($banks) . "\n";
    }
}

echo "\n=== Server is READY! ===\n";
echo "\nOpen in browser: http://localhost:8000/index.html\n";


