<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Merchant Onboarding - Fingpay AEPS</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
        }

        .header {
            text-align: center;
            color: white;
            margin-bottom: 30px;
        }

        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
        }

        .card {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        .required {
            color: red;
        }

        input[type="text"],
        input[type="email"],
        input[type="tel"],
        input[type="number"],
        select,
        textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }

        input:focus,
        select:focus,
        textarea:focus {
            outline: none;
            border-color: #667eea;
        }

        textarea {
            resize: vertical;
            min-height: 80px;
        }

        .btn-submit {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s;
            margin-top: 10px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .response-container {
            margin-top: 20px;
            padding: 20px;
            border-radius: 8px;
            display: none;
        }

        .response-container.show {
            display: block;
            animation: slideDown 0.3s;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .response-success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }

        .response-error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .loading {
            display: none;
            text-align: center;
            padding: 20px;
        }

        .loading.show {
            display: block;
        }

        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .back-link {
            display: inline-block;
            color: white;
            text-decoration: none;
            margin-bottom: 20px;
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            transition: background 0.3s;
        }

        .back-link:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="index.php" class="back-link">← Back to Portal</a>
        
            <div class="header">
            <h1>🏪 Merchant Onboarding</h1>
            <p>Register your merchant account with Fingpay AEPS</p>
        </div>

        <div class="card">
            <form id="onboardForm">
                <h2 style="margin-bottom: 20px; color: #333;">Merchant Information</h2>
                
                <div class="form-group">
                    <label>Merchant Name <span class="required">*</span></label>
                    <input type="text" name="merchantName" required placeholder="Enter merchant/business name">
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label>Mobile Number <span class="required">*</span></label>
                        <input type="tel" name="merchantMobile" required maxlength="10" pattern="[0-9]{10}" placeholder="10 digit mobile number">
                    </div>
                    <div class="form-group">
                        <label>Email Address <span class="required">*</span></label>
                        <input type="email" name="merchantEmail" required placeholder="merchant@example.com">
                    </div>
                </div>

                <div class="form-group">
                    <label>Business Address <span class="required">*</span></label>
                    <textarea name="merchantAddress" required placeholder="Enter complete business address"></textarea>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label>City <span class="required">*</span></label>
                        <input type="text" name="merchantCity" required placeholder="City name">
                    </div>
                    <div class="form-group">
                        <label>State <span class="required">*</span></label>
                        <input type="text" name="merchantState" required placeholder="State name">
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label>Pincode <span class="required">*</span></label>
                        <input type="text" name="merchantPincode" required maxlength="6" pattern="[0-9]{6}" placeholder="6 digit pincode">
                    </div>
                <div class="form-group">
                    <label>Business Type <span class="required">*</span></label>
                    <select name="businessType" required>
                        <option value="">Select Business Type</option>
                        <option value="RETAIL">Retail</option>
                        <option value="WHOLESALE">Wholesale</option>
                        <option value="SERVICES">Services</option>
                        <option value="RESTAURANT">Restaurant</option>
                        <option value="GROCERY">Grocery</option>
                        <option value="MEDICAL">Medical</option>
                        <option value="EDUCATION">Education</option>
                        <option value="OTHER">Other</option>
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label>GST Number</label>
                    <input type="text" name="gstNumber" placeholder="Enter GST number (optional)">
                </div>
                <div class="form-group">
                    <label>PAN Number</label>
                    <input type="text" name="panNumber" placeholder="Enter PAN number (optional)">
                </div>
            </div>

            <div class="form-group">
                <label>Device IMEI</label>
                <input type="text" name="deviceIMEI" placeholder="Enter device IMEI (optional)">
                <small style="color: #666; font-size: 12px;">Leave empty to use default device</small>
            </div>

                <button type="submit" class="btn-submit">Register Merchant</button>
            </form>

            <div class="loading" id="loading">
                <div class="spinner"></div>
                <p>Registering merchant...</p>
            </div>

            <div class="response-container" id="response"></div>
        </div>
    </div>

    <script>
        document.getElementById('onboardForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            const data = Object.fromEntries(formData);

            // Show loading
            document.getElementById('loading').classList.add('show');
            document.getElementById('response').classList.remove('show');

            // Send AJAX request
            fetch('api_handler.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    type: 'merchant_onboard',
                    data: data
                })
            })
            .then(response => response.json())
            .then(result => {
                document.getElementById('loading').classList.remove('show');
                const responseDiv = document.getElementById('response');
                responseDiv.classList.add('show');
                
                if (result.status === 'success') {
                    responseDiv.className = 'response-container show response-success';
                    responseDiv.innerHTML = '<div><strong>✅ Registration Successful!</strong><br><br>' +
                        '<pre>' + JSON.stringify(result.data, null, 2) + '</pre></div>';
                    
                    // Optionally reset form
                    // document.getElementById('onboardForm').reset();
                } else {
                    responseDiv.className = 'response-container show response-error';
                    responseDiv.innerHTML = '<div><strong>❌ Registration Failed</strong><br><br>' +
                        '<pre>' + (result.message || JSON.stringify(result, null, 2)) + '</pre></div>';
                }
            })
            .catch(error => {
                document.getElementById('loading').classList.remove('show');
                const responseDiv = document.getElementById('response');
                responseDiv.classList.add('show');
                responseDiv.className = 'response-container show response-error';
                responseDiv.innerHTML = '<div><strong>❌ Error</strong><br><br>Error: ' + error.message + '</div>';
            });
        });
    </script>
</body>
</html>

