<?php
/**
 * Example usage of FingpayAEPS class
 * 
 * This file demonstrates how to use the Fingpay AEPS API integration
 */

require_once 'FingpayAEPS.php';

// Path to the public certificate file
$certPath = __DIR__ . '/../fingpay_public_production.txt';

try {
    // Initialize the Fingpay AEPS client
    $fingpay = new FingpayAEPS($certPath, 30);
    
    // Example: Cash Withdrawal
    echo "=== Cash Withdrawal Example ===\n";
    $withdrawalResponse = $fingpay->cashWithdrawal(
        'MERCHANT_ID',           // Merchant ID
        'TERMINAL_ID',           // Terminal ID
        '123456789012',          // Aadhaar Number
        1000.00,                 // Amount
        'John Doe',              // Customer Name
        'TXN' . time(),          // Transaction Reference (unique)
        'BANK_CODE',             // Bank Code
        'DEVICE_IMEI',           // Device IMEI (optional)
        []                       // Additional parameters (optional)
    );
    print_r($withdrawalResponse);
    echo "\n\n";
    
    // Example: Balance Inquiry
    echo "=== Balance Inquiry Example ===\n";
    $balanceResponse = $fingpay->balanceInquiry(
        'MERCHANT_ID',           // Merchant ID
        'TERMINAL_ID',           // Terminal ID
        '123456789012',          // Aadhaar Number
        'BANK_CODE',             // Bank Code
        'TXN' . time(),          // Transaction Reference (unique)
        'DEVICE_IMEI'            // Device IMEI (optional)
    );
    print_r($balanceResponse);
    echo "\n\n";
    
    // Example: Mini Statement
    echo "=== Mini Statement Example ===\n";
    $statementResponse = $fingpay->miniStatement(
        'MERCHANT_ID',           // Merchant ID
        'TERMINAL_ID',           // Terminal ID
        '123456789012',          // Aadhaar Number
        'BANK_CODE',             // Bank Code
        'TXN' . time(),          // Transaction Reference (unique)
        'DEVICE_IMEI'            // Device IMEI (optional)
    );
    print_r($statementResponse);
    echo "\n\n";
    
    // Example: Cash Deposit
    echo "=== Cash Deposit Example ===\n";
    $depositResponse = $fingpay->cashDeposit(
        'MERCHANT_ID',           // Merchant ID
        'TERMINAL_ID',           // Terminal ID
        '123456789012',          // Aadhaar Number
        500.00,                  // Amount
        'Jane Doe',              // Customer Name
        'TXN' . time(),          // Transaction Reference (unique)
        'BANK_CODE',             // Bank Code
        'DEVICE_IMEI',           // Device IMEI (optional)
        []                       // Additional parameters (optional)
    );
    print_r($depositResponse);
    echo "\n\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

