<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EKYC Verification - Fingpay AEPS</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
        }

        .header {
            text-align: center;
            color: white;
            margin-bottom: 30px;
        }

        .header h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
        }

        .card {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            border-bottom: 2px solid #e0e0e0;
        }

        .tab-button {
            padding: 12px 24px;
            background: transparent;
            color: #666;
            border: none;
            border-bottom: 3px solid transparent;
            cursor: pointer;
            font-size: 16px;
            transition: all 0.3s;
        }

        .tab-button:hover {
            color: #667eea;
        }

        .tab-button.active {
            color: #667eea;
            border-bottom-color: #667eea;
            font-weight: bold;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        .required {
            color: red;
        }

        input[type="text"],
        input[type="tel"],
        textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }

        input:focus,
        textarea:focus {
            outline: none;
            border-color: #667eea;
        }

        .btn-submit {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s;
            margin-top: 10px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .response-container {
            margin-top: 20px;
            padding: 20px;
            border-radius: 8px;
            display: none;
        }

        .response-container.show {
            display: block;
            animation: slideDown 0.3s;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .response-success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }

        .response-error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .loading {
            display: none;
            text-align: center;
            padding: 20px;
        }

        .loading.show {
            display: block;
        }

        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .back-link {
            display: inline-block;
            color: white;
            text-decoration: none;
            margin-bottom: 20px;
            padding: 10px 20px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            transition: background 0.3s;
        }

        .back-link:hover {
            background: rgba(255, 255, 255, 0.3);
        }

        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196f3;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }

        .info-box p {
            margin: 5px 0;
            color: #1565c0;
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="index.php" class="back-link">← Back to Portal</a>
        
        <div class="header">
            <h1>🆔 EKYC Verification</h1>
            <p>Electronic KYC using Aadhaar</p>
        </div>

        <div class="card">
            <div class="tabs">
                <button class="tab-button active" onclick="showTab('verify')">EKYC Verify</button>
                <button class="tab-button" onclick="showTab('enroll')">EKYC Enroll</button>
                <button class="tab-button" onclick="showTab('status')">Check Status</button>
            </div>

            <!-- EKYC Verify Tab -->
            <div id="verify" class="tab-content active">
                <h2>EKYC Verification</h2>
                <div class="info-box">
                    <p><strong>📋 Process:</strong></p>
                    <p>1. Enter Aadhaar number</p>
                    <p>2. OTP will be sent to registered mobile (if required)</p>
                    <p>3. Enter OTP to verify</p>
                </div>
                
                <form id="verifyForm">
                    <div class="form-group">
                        <label>Aadhaar Number <span class="required">*</span></label>
                        <input type="tel" name="aadhaarNumber" required maxlength="12" pattern="[0-9]{12}" placeholder="Enter 12 digit Aadhaar number">
                    </div>

                    <div class="form-group">
                        <label>OTP (if received)</label>
                        <input type="text" name="otp" maxlength="6" placeholder="Enter OTP received on mobile">
                    </div>

                    <div class="form-group">
                        <label>Biometric Data (Base64)</label>
                        <textarea name="biometricData" rows="3" placeholder="Enter base64 encoded biometric/fingerprint data (optional)"></textarea>
                    </div>

                    <div class="form-group">
                        <label>Biometric Type</label>
                        <select name="biometricType">
                            <option value="FINGERPRINT">Fingerprint</option>
                            <option value="IRIS">Iris</option>
                            <option value="FACE">Face</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Device IMEI</label>
                        <input type="text" name="deviceIMEI" placeholder="Enter device IMEI (optional)">
                    </div>

                    <button type="submit" class="btn-submit">Verify EKYC</button>
                </form>

                <div class="loading" id="verifyLoading">
                    <div class="spinner"></div>
                    <p>Verifying EKYC...</p>
                </div>

                <div class="response-container" id="verifyResponse"></div>
            </div>

            <!-- EKYC Enroll Tab -->
            <div id="enroll" class="tab-content">
                <h2>EKYC Enrollment</h2>
                <form id="enrollForm">
                    <div class="form-group">
                        <label>Aadhaar Number <span class="required">*</span></label>
                        <input type="tel" name="aadhaarNumber" required maxlength="12" pattern="[0-9]{12}" placeholder="Enter 12 digit Aadhaar number">
                    </div>

                    <div class="form-group">
                        <label>Mobile Number <span class="required">*</span></label>
                        <input type="tel" name="mobileNumber" required maxlength="10" pattern="[0-9]{10}" placeholder="10 digit mobile number">
                    </div>

                    <div class="form-group">
                        <label>Name <span class="required">*</span></label>
                        <input type="text" name="name" required placeholder="Enter full name">
                    </div>

                    <div class="form-group">
                        <label>Date of Birth</label>
                        <input type="date" name="dateOfBirth">
                    </div>

                    <div class="form-group">
                        <label>Address</label>
                        <textarea name="address" rows="3" placeholder="Enter address"></textarea>
                    </div>

                    <div class="form-group">
                        <label>Device IMEI</label>
                        <input type="text" name="deviceIMEI" placeholder="Enter device IMEI (optional)">
                    </div>

                    <button type="submit" class="btn-submit">Enroll for EKYC</button>
                </form>

                <div class="loading" id="enrollLoading">
                    <div class="spinner"></div>
                    <p>Enrolling for EKYC...</p>
                </div>

                <div class="response-container" id="enrollResponse"></div>
            </div>

            <!-- Check Status Tab -->
            <div id="status" class="tab-content">
                <h2>Check EKYC Status</h2>
                <form id="statusForm">
                    <div class="form-group">
                        <label>Reference ID <span class="required">*</span></label>
                        <input type="text" name="referenceId" required placeholder="Enter reference ID from EKYC request">
                    </div>

                    <div class="form-group">
                        <label>Device IMEI</label>
                        <input type="text" name="deviceIMEI" placeholder="Enter device IMEI (optional)">
                    </div>

                    <button type="submit" class="btn-submit">Check Status</button>
                </form>

                <div class="loading" id="statusLoading">
                    <div class="spinner"></div>
                    <p>Checking status...</p>
                </div>

                <div class="response-container" id="statusResponse"></div>
            </div>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            // Hide all tabs
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.remove('active');
            });
            document.querySelectorAll('.tab-button').forEach(btn => {
                btn.classList.remove('active');
            });

            // Show selected tab
            document.getElementById(tabName).classList.add('active');
            event.target.classList.add('active');
        }

        // EKYC Verify Form
        document.getElementById('verifyForm').addEventListener('submit', function(e) {
            e.preventDefault();
            submitEKYCRequest('ekyc_verify', new FormData(this));
        });

        // EKYC Enroll Form
        document.getElementById('enrollForm').addEventListener('submit', function(e) {
            e.preventDefault();
            submitEKYCRequest('ekyc_enroll', new FormData(this));
        });

        // EKYC Status Form
        document.getElementById('statusForm').addEventListener('submit', function(e) {
            e.preventDefault();
            submitEKYCRequest('ekyc_status', new FormData(this));
        });

        function submitEKYCRequest(type, formData) {
            const data = Object.fromEntries(formData);
            const loadingId = type + 'Loading';
            const responseId = type + 'Response';

            // Show loading
            document.getElementById(loadingId).classList.add('show');
            document.getElementById(responseId).classList.remove('show');

            // Send AJAX request
            fetch('api_handler.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    type: type,
                    data: data
                })
            })
            .then(response => response.json())
            .then(result => {
                document.getElementById(loadingId).classList.remove('show');
                const responseDiv = document.getElementById(responseId);
                responseDiv.classList.add('show');
                
                if (result.status === 'success') {
                    responseDiv.className = 'response-container show response-success';
                    responseDiv.innerHTML = '<div><strong>✅ Success!</strong><br><br>' +
                        '<pre>' + JSON.stringify(result.data, null, 2) + '</pre></div>';
                } else {
                    responseDiv.className = 'response-container show response-error';
                    responseDiv.innerHTML = '<div><strong>❌ Failed</strong><br><br>' +
                        '<pre>' + (result.message || JSON.stringify(result, null, 2)) + '</pre></div>';
                }
            })
            .catch(error => {
                document.getElementById(loadingId).classList.remove('show');
                const responseDiv = document.getElementById(responseId);
                responseDiv.classList.add('show');
                responseDiv.className = 'response-container show response-error';
                responseDiv.innerHTML = '<div><strong>❌ Error</strong><br><br>Error: ' + error.message + '</div>';
            });
        }
    </script>
</body>
</html>

