<?php
/**
 * Fingpay API Configuration
 * 
 * All API endpoints, base URLs, and credentials are defined here.
 * Update these values according to Fingpay API documentation.
 */

return [
    /**
     * Base API URL
     */
    'base_url' => 'https://fingpayap.tapits.in',
    
    /**
     * Fingpay Credentials
     * From FingPayConfig class
     */
    'credentials' => [
        'super_merchant_id' => 1143,
        'merchant_id' => 1143, // Using super_merchant_id as merchant_id
        'username' => 'Paydeer',
        'password' => 'Paydeer@2025',
        'secret_key' => 'f9e7b2fb3be7911d28f5556abed05923181268a4f4100b6d0a1988abc7b15ba8',
        'default_device_imei' => '8982848',
        'ip_address' => '82.29.165.61',
    ],
    
    /**
     * API Endpoints
     * Based on Fingpay API documentation pattern: /fpaepsservice/api/{serviceName}/merchant/{action}
     */
    'endpoints' => [
        // Transaction APIs - Using /merchant/php/ pattern as per sample code
        'cash_withdrawal' => '/fpaepsservice/api/cashWithdrawal/merchant/php/withdrawal',
        'balance_inquiry' => '/fpaepsservice/api/balanceInquiry/merchant/php/inquiry',
        'mini_statement' => '/fpaepsservice/api/miniStatement/merchant/php/statement',
        'cash_deposit' => '/fpaepsservice/api/cashDeposit/merchant/php/deposit',
        
        // User Onboarding APIs - NOT AVAILABLE IN DOCUMENTATION (Disabled)
        // 'user_onboard' => '/fpaepsservice/api/userOnboard/merchant/php/register',
        // 'user_verify' => '/fpaepsservice/api/userOnboard/merchant/php/verify',
        
        // Merchant Onboarding API - NOT AVAILABLE (Disabled - handled externally)
        'merchant_onboard' => '/fpaepsservice/api/merchantOnboard/merchant/php/register',
        'merchant_status' => '/fpaepsservice/api/merchantOnboard/merchant/php/status',
        
        // EKYC APIs - Based on documentation pattern
        'ekyc_verify' => '/fpaepsservice/api/ekyc/merchant/php/verify',
        'ekyc_status' => '/fpaepsservice/api/ekyc/merchant/php/status',
        'ekyc_enroll' => '/fpaepsservice/api/ekyc/merchant/php/enroll',
        
        // Bank List endpoint
        'bank_list' => '/fpaepsservice/api/bankList',
    ],
    
    /**
     * Certificate Path
     * Note: The provided path is /app/storage/fingpay_pub.pem
     * Using local path, update if different
     */
    'certificate_path' => __DIR__ . '/../fingpay_public_production.txt',
    
    /**
     * AES Encryption IV (fixed as per API documentation)
     */
    'aes_iv' => '06f2f04cc530364f',
    
    /**
     * Request timeout in seconds
     */
    'timeout' => 30,
    
    /**
     * Bank list API configuration
     * Some APIs might return bank list without encryption
     */
    'bank_list_config' => [
        'requires_encryption' => false, // Set to true if bank list API requires encryption
        'method' => 'GET', // or 'POST'
    ],
];

