# XAMPP Setup Guide (हिंदी)

## ✅ आपका Code XAMPP में Setup हो गया है!

आपका AEPS project XAMPP के htdocs folder में setup हो चुका है।

## 🌐 Project Access करने के लिए:

1. **XAMPP Control Panel खोलें**
2. **Apache Server Start करें** (Start button click करें)
3. **Browser में निम्नलिखित URL खोलें:**
   ```
   http://localhost/AEPS/code/
   ```
   या
   ```
   http://localhost/AEPS/code/index.php
   ```

## 📁 Folder Structure:

```
C:\xampp\htdocs\AEPS\
├── code\                    (मुख्य code folder)
│   ├── index.php           (Web Interface - यहाँ से खोलें!)
│   ├── api_handler.php     (API Handler)
│   ├── FingpayAEPS.php     (Main AEPS Class)
│   ├── api_config.php      (Configuration)
│   └── ...
├── fingpay_public_production.txt  (Certificate file ✅)
└── ...
```

## ⚙️ Configuration:

### Certificate Path:
Certificate file का path सही है: `../fingpay_public_production.txt`

### Credentials:
Credentials `api_config.php` file में configure हैं:
- Merchant ID: 1143
- Username: Paydeer
- Password: Paydeer@2025
- Default Device IMEI: 8982848

## 🔧 Troubleshooting:

### अगर Page नहीं खुल रहा है:

1. **Apache Service Check करें:**
   - XAMPP Control Panel में Apache "Running" status में होना चाहिए
   - अगर नहीं है, तो Start button click करें

2. **Port Check करें:**
   - Default port 80 है
   - अगर port conflict है, तो `http://localhost:8080/AEPS/code/` try करें
   - Port change करने के लिए XAMPP → Apache → Config → httpd.conf में `Listen 8080` करें

3. **PHP Extension Check:**
   - `php.ini` में `extension=openssl` enabled होना चाहिए
   - `php.ini` में `extension=curl` enabled होना चाहिए

4. **File Permissions:**
   - सभी files readable होनी चाहिए
   - Certificate file accessible होना चाहिए

### PHP Errors देखने के लिए:

1. `php.ini` file खोलें (XAMPP → Apache → Config → php.ini)
2. ये lines uncomment करें:
   ```ini
   display_errors = On
   error_reporting = E_ALL
   ```
3. Apache restart करें

## 📋 Quick Test:

### Test 1: Server Check
```
http://localhost/AEPS/code/test_server.php
```

### Test 2: Bank List API
```
http://localhost/AEPS/code/get_bank_list.php
```

### Test 3: Main Interface
```
http://localhost/AEPS/code/index.php
```

## 🎯 Main Features:

1. **Cash Withdrawal** - Cash निकालने के लिए
2. **Balance Inquiry** - Balance check करने के लिए
3. **Mini Statement** - Mini statement देखने के लिए
4. **Cash Deposit** - Cash deposit करने के लिए
5. **Bank List** - Aadhaar enabled banks की list

## 📞 Support:

अगर कोई issue है तो:
1. Browser Console check करें (F12 दबाएं)
2. Apache error logs check करें (XAMPP → Apache → Logs)
3. PHP error logs check करें

## ✅ Setup Complete!

अब आप अपने browser में `http://localhost/AEPS/code/index.php` खोलकर AEPS portal use कर सकते हैं!

---

**Note:** Production में deploy करने से पहले:
- SSL certificate configure करें
- Credentials को secure करें
- API endpoints verify करें
- Error handling और logging add करें

