# Fingpay AEPS - Quick Start Guide (हिंदी)

## 🚀 प्रोजेक्ट कैसे चलाएं

### **Option 1: XAMPP के बिना (सरल तरीका) ⭐**

#### आवश्यकताएं:
1. **PHP installed होना चाहिए**
   - Check करें: `php -v` terminal में run करें
   - अगर नहीं है, तो [PHP Download](https://www.php.net/downloads.php) करें

#### Steps:

**Step 1:** Terminal/Command Prompt खोलें

**Step 2:** `code` folder में जाएं:
```bash
cd C:\Users\theha\Downloads\AEPS\AEPS\code
```

**Step 3:** PHP server start करें:
```bash
php -S localhost:8000
```

**Step 4:** Browser में खोलें:
```
http://localhost:8000/index.html
```

✅ **बस! प्रोजेक्ट चल रहा है!**

---

### **Option 2: XAMPP के साथ**

अगर आप XAMPP use करना चाहते हैं:

**Step 1:** XAMPP install करें (अगर नहीं है)
- [XAMPP Download](https://www.apachefriends.org/)

**Step 2:** XAMPP start करें
- XAMPP Control Panel खोलें
- **Apache** start करें

**Step 3:** Project folder copy करें:
- `code` folder को `C:\xampp\htdocs\` में copy करें
- या `C:\xampp\htdocs\AEPS\` बनाकर सभी files copy करें

**Step 4:** Browser में खोलें:
```
http://localhost/AEPS/code/index.html
```
या अगर directly code folder में copy किया:
```
http://localhost/index.html
```

---

## 📋 दोनों Options की तुलना

| Feature | PHP Built-in Server | XAMPP |
|---------|---------------------|-------|
| **Installation** | सिर्फ PHP चाहिए | XAMPP + PHP |
| **Setup Time** | 1 मिनट | 5-10 मिनट |
| **Port** | 8000 (customizable) | 80 (default) |
| **Best For** | Quick Testing | Production-like setup |
| **Difficulty** | ⭐ Easy | ⭐⭐ Medium |

---

## ✅ Recommended: PHP Built-in Server

**क्यों?**
- ✅ बिना installation के चल जाता है
- ✅ Setup बहुत आसान
- ✅ Testing के लिए perfect
- ✅ कोई extra configuration नहीं

---

## 🔍 PHP Check करना

अगर PHP installed है या नहीं, check करें:

**Windows:**
```cmd
php -v
```

**अगर error आए:**
1. PHP install करें: [PHP Downloads](https://www.php.net/downloads.php)
2. PHP को PATH में add करें
3. या XAMPP install करें (उसमें PHP included है)

---

## 🛠️ Step-by-Step (PHP Built-in Server)

### 1. Terminal खोलें:
- **Windows**: `Win + R` → `cmd` → Enter
- या PowerShell खोलें

### 2. Project folder में जाएं:
```cmd
cd C:\Users\theha\Downloads\AEPS\AEPS\code
```

### 3. Server start करें:
```cmd
php -S localhost:8000
```

**Output दिखेगा:**
```
PHP 7.4.x Development Server started
Listening on http://localhost:8000
Document root is C:\Users\theha\Downloads\AEPS\AEPS\code
Press Ctrl-C to quit
```

### 4. Browser में खोलें:
- Chrome/Firefox/Edge में जाएं
- Address bar में type करें: `http://localhost:8000/index.html`
- Enter दबाएं

### 5. Website खुल जाएगी! 🎉

---

## ⚠️ Common Issues & Solutions

### Issue 1: "php: command not found"

**Solution:**
- PHP install नहीं है
- Option A: [PHP Download](https://www.php.net/downloads.php) करें
- Option B: XAMPP install करें (recommended for beginners)

### Issue 2: "Port 8000 already in use"

**Solution:**
- दूसरा port use करें:
```cmd
php -S localhost:8080
```
- Browser में: `http://localhost:8080/index.html`

### Issue 3: "Certificate file not found"

**Solution:**
- Check करें: `fingpay_public_production.txt` file parent folder में है या नहीं
- Path: `C:\Users\theha\Downloads\AEPS\AEPS\fingpay_public_production.txt`

### Issue 4: "Access Denied"

**Solution:**
- Administrator के रूप में terminal run करें
- File permissions check करें

---

## 📝 Quick Commands Cheat Sheet

```bash
# Server start करने के लिए
php -S localhost:8000

# दूसरा port use करने के लिए
php -S localhost:8080

# Specific folder से run करने के लिए
php -S localhost:8000 -t C:\path\to\code

# Server stop करने के लिए
Ctrl + C (terminal में)
```

---

## 🎯 Final Recommendation

**नए users के लिए:**
1. XAMPP install करें (सबसे आसान)
2. `code` folder को `htdocs` में copy करें
3. Apache start करें
4. Browser में `http://localhost/index.html` खोलें

**Advanced users के लिए:**
1. PHP already installed है
2. `php -S localhost:8000` run करें
3. Done! ✅

---

## 💡 Tips

- Server running रहेगा जब तक आप `Ctrl+C` नहीं दबाते
- Browser में कई tabs खोल सकते हैं
- Code change करने के बाद refresh करें
- Error messages console में दिखेंगी (F12 दबाकर देखें)

---

## ✅ Testing Checklist

- [ ] PHP installed है
- [ ] `code` folder में terminal खोला
- [ ] `php -S localhost:8000` command run किया
- [ ] Browser में `http://localhost:8000/index.html` खोला
- [ ] Website load हो गई
- [ ] सभी tabs दिख रहे हैं
- [ ] Bank list load हो रही है

---

**Need Help?** 
- Browser console खोलें (F12)
- Errors check करें
- `api_config.php` में credentials verify करें
- Certificate file path check करें

