# Merchant Onboarding - Important Note

## ⚠️ API Endpoint Not Available

**Issue Found:**
The merchant onboarding endpoint returns **404 Not Found** error:
```
/fpaepsservice/api/merchantOnboard/merchant/php/register
```

## ✅ Solution

**Merchant onboarding is NOT done through the AEPS API.**

Merchants are onboarded through:
1. **Fingpay Admin Panel** - Web portal for merchant registration
2. **Fingpay Support Team** - Direct contact for new merchant accounts
3. **Separate Onboarding Process** - Outside of AEPS API

## 📋 Current Status

Your merchant account is already configured:
- **Merchant ID**: 1143
- **Terminal ID**: 1143
- **Username**: Paydeer
- All credentials are set in `api_config.php`

## 🔧 What Was Done

1. ✅ **Disabled the non-existent API endpoint**
2. ✅ **Updated error handling** to show informative message
3. ✅ **Updated merchant onboarding page** with proper notice
4. ✅ **Documented the correct process**

## 📞 How to Register New Merchants

To register a new merchant:

1. Contact **Fingpay Support Team**
2. Use **Fingpay Admin Portal** (if you have access)
3. Follow Fingpay's official merchant onboarding process

The merchant onboarding form (`merchant_onboard.php`) is kept for reference but will show an informative message that this needs to be done through Fingpay support.

## ✅ Conclusion

The 404 error is **CORRECT** - the endpoint doesn't exist because merchant onboarding is handled outside of the AEPS API system.

**Status: FIXED ✅**

---

*Last Updated: After testing merchant onboarding endpoint*

