# ✅ APIs According to Documentation Only

## 📋 **Documented APIs in Fingpay Services API Doc 04-01-2025 (8).pdf**

### ✅ **Active APIs (In Documentation):**

1. **Cash Withdrawal** ✅
   - Endpoint: `/fpaepsservice/api/cashWithdrawal/merchant/php/withdrawal`
   - Status: Active

2. **Balance Inquiry** ✅
   - Endpoint: `/fpaepsservice/api/balanceInquiry/merchant/php/inquiry`
   - Status: Active

3. **Mini Statement** ✅
   - Endpoint: `/fpaepsservice/api/miniStatement/merchant/php/statement`
   - Status: Active

4. **Cash Deposit** ✅
   - Endpoint: `/fpaepsservice/api/cashDeposit/merchant/php/deposit`
   - Status: Active

5. **Bank List** ✅
   - Endpoint: `/fpaepsservice/api/bankList`
   - Status: Active

---

## ❌ **Disabled APIs (NOT in Documentation):**

1. **User Onboarding** ❌
   - Endpoint: `/fpaepsservice/api/userOnboard/merchant/php/register` (Disabled)
   - Endpoint: `/fpaepsservice/api/userOnboard/merchant/php/verify` (Disabled)
   - Reason: Not found in official documentation
   - Status: **DISABLED**

2. **Merchant Onboarding** ❌
   - Endpoint: `/fpaepsservice/api/merchantOnboard/merchant/php/register` (Not Available)
   - Endpoint: `/fpaepsservice/api/merchantOnboard/merchant/php/status` (Not Available)
   - Reason: Handled externally, not via API
   - Status: **DISABLED**

---

## ❓ **Uncertain APIs (Need Verification):**

1. **EKYC APIs** ❓
   - `/fpaepsservice/api/ekyc/merchant/php/verify`
   - `/fpaepsservice/api/ekyc/merchant/php/status`
   - `/fpaepsservice/api/ekyc/merchant/php/enroll`
   - Status: **NEEDS PDF VERIFICATION**

---

## ✅ **Current Implementation Status:**

### **Available Forms/Pages:**
- ✅ Cash Withdrawal Form
- ✅ Balance Inquiry Form
- ✅ Mini Statement Form
- ✅ Cash Deposit Form
- ✅ Bank List Display
- ❌ User Onboarding (Disabled - Shows informative message)
- ❌ Merchant Onboarding (Disabled - Shows informative message)
- ❓ EKYC Verification (Needs verification)

---

## 📝 **Notes:**

1. **User Onboarding:**
   - Was implemented based on assumption
   - Not found in documentation
   - **DISABLED** - Page shows informative message

2. **Merchant Onboarding:**
   - Not available via API
   - Handled externally (admin panel/support)
   - **DISABLED** - Page shows informative message

3. **EKYC APIs:**
   - Implemented but needs PDF verification
   - Currently active but should be verified
   - If not in documentation, should be disabled

---

## 🎯 **What's Active Now:**

**Only APIs that are confirmed in documentation are active:**

1. ✅ Transaction APIs (4 APIs)
2. ✅ Bank List API
3. ❌ User Onboarding - Disabled
4. ❌ Merchant Onboarding - Disabled
5. ❓ EKYC - Needs verification

---

**Last Updated:** After disabling User Onboarding API per documentation review

