# Fingpay Credentials Integration

## ✅ Credentials Successfully Integrated

All Fingpay credentials from `FingPayConfig` have been integrated into the system.

## Credentials Added

The following credentials are now configured in `api_config.php`:

- **Super Merchant ID**: `1143`
- **Merchant ID**: `1143`
- **Username**: `Paydeer`
- **Password**: `Paydeer@2025`
- **Secret Key**: `f9e7b2fb3be7911d28f5556abed05923181268a4f4100b6d0a1988abc7b15ba8`
- **Default Device IMEI**: `8982848`
- **IP Address**: `82.29.165.61`

## Files Updated

### 1. `api_config.php`
- Added `credentials` section with all Fingpay credentials
- Credentials are centralized for easy management
- Added `certificate_path` configuration

### 2. `api_handler.php`
- Updated to load credentials from `api_config.php`
- No more hardcoded placeholder values
- Automatically uses credentials from configuration

### 3. `get_bank_list.php`
- Updated to use merchant ID from configuration
- Uses certificate path from configuration

## Usage

All credentials are automatically loaded from the configuration file. No code changes needed to use them.

The system will use:
- `merchant_id: 1143` for all transactions
- `terminal_id: 1143` (using merchant_id as terminal_id)
- `device_imei: 8982848` as default device IMEI

## Configuration Location

All credentials are stored in:
```
code/api_config.php
```

## Security Note

⚠️ **Important**: The `api_config.php` file contains sensitive credentials. Ensure:
- File permissions are restricted (chmod 600 recommended)
- File is not publicly accessible via web
- Consider adding to `.gitignore` if using version control
- Use environment variables or secure vault for production

## Testing

After integration, test the API calls:
1. Open `index.html` in browser
2. Try a Balance Inquiry transaction
3. Check browser console for any errors
4. Verify transactions use correct merchant ID (1143)

## Additional Credentials Usage

If the Fingpay API requires `username`, `password`, or `secret_key` in request headers or authentication, you can access them in `api_handler.php`:

```php
$USERNAME = $credentials['username'];      // 'Paydeer'
$PASSWORD = $credentials['password'];      // 'Paydeer@2025'
$SECRET_KEY = $credentials['secret_key'];  // Secret key
$IP_ADDRESS = $credentials['ip_address'];   // '82.29.165.61'
```

These are available but currently not used in headers as the current API implementation uses hash and eskey for authentication.

## Next Steps

1. ✅ Credentials integrated
2. ✅ Configuration centralized
3. Test API transactions with actual credentials
4. Monitor API responses for any authentication requirements
5. Update headers if username/password/secret_key are required

## Notes

- The `terminal_id` is currently set to the same value as `merchant_id` (1143)
- If your system requires a separate terminal ID, update it in `api_config.php`
- The IP address is stored but not currently used in API calls
- If the API requires IP whitelisting, ensure `82.29.165.61` is whitelisted with Fingpay

